IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cbtes_Grabar_Numero') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cbtes_Grabar_Numero
END
GO


CREATE PROCEDURE [dbo].[CPJ_Cbtes_Grabar_Numero] @pJson VARCHAR(8000)
AS
SET NOCOUNT ON
 
/*Variables recibidas por parámetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Trans				INT
DECLARE @pOmitir_Resultado_OK	TINYINT
 
 
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pOmitir_Resultado_OK		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')), 0)
/*FIN Variables recibidas por parámetro a traves del JSON*/
 
/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
/*FIN Variable de Retorono del Stored*/
 
/*Declaracion Variables Locales*/
DECLARE @Mensaje							VARCHAR(100)
DECLARE @Id_Tipo_Cbte						CHAR(4)
DECLARE @Fecha_Cai							DATETIME
DECLARE @Nro_Cai							VARCHAR(14)
DECLARE @Flag_Val_Correla					TINYINT
DECLARE @Compromete_Factura					SMALLINT
DECLARE @Fecha								DATETIME
DECLARE @Fecha_Cbte							DATETIME
DECLARE @Comprobante_Nro					INT
DECLARE @Id_Estado_Cbte						SMALLINT
DECLARE @Id_Cond_Pago						SMALLINT
DECLARE @Compromete_Recibos					SMALLINT
DECLARE @Compromete_Pagos					SMALLINT
/*Fin de Declaraciones Variables Locales */
BEGIN TRY
 
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Grabar_Numero'
		PRINT 'Parámetros:'
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + ' Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans)
	END
 
	/*===================================================================*/
 
	IF(@pId_Trans = 0)
	BEGIN
		SET @rtaErrorStored = 70001 /*Transaccion no abierta*/
		SELECT	 @rtaErrorStored	AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,''					AS ErrorMessage
		IF @pFlagUsarTrans <> 0 
		BEGIN
			ROLLBACK
		END
		RETURN 9999
	END
	/*===================================================================*/	
 
	SELECT	@Id_Tipo_Cbte = ISNULL(T.Id_Tipo_Cbte,''),
			@Fecha_Cai = ISNULL(T.Fecha_Cai, '19000101'),
			@Nro_Cai = ISNULL(T.Nro_Cai, 0),
			@Flag_Val_Correla = ISNULL(T.Flag_Val_Correla,0),
			@Compromete_Factura = ISNULL(T.Compromete_Factura,0),
			@Id_Estado_Cbte = ISNULL(T.Id_Estado_Cbte,0),
			@Id_Cond_Pago = ISNULL(C.Id_Cond_Pago,0),
			@Compromete_Recibos = ISNULL(Compromete_Recibos,0),
			@Compromete_Pagos	= ISNULL(Compromete_Pagos,0),
			@Fecha_Cbte = C.Fecha,
			@Comprobante_Nro = ISNULL(T.Prox_Nro,1)
	FROM Cbtes_Tipos T, Cbtes C
	WHERE 
	T.Id_Tipo_Cbte = dbo.CF_Cbte_Traer_Tipo_Dest(C.Id_Tipo_Cbte)
	AND C.Id_Trans = @pId_Trans
 
    IF @Flag_Val_Correla = 1 OR (@Compromete_Factura <> 0 AND CAST( dbo.CF_xParam('Fact_Cont_FN') AS INT ) <> 0 )
	BEGIN
	    /*
		SELECT	@Fecha = MAX(Fecha),
				@Comprobante_Nro = ISNULL(MAX(Comprobante_Nro),0) + 1 FROM Cbtes 
		WHERE 
		(Id_Tipo_Cbte = @Id_Tipo_Cbte OR Id_Tipo_Cbte  IN (	SELECT Id_Tipo_Cbte 
															FROM Cbtes_Tipos 
															WHERE Id_Tipo_Cbte_Dest = @Id_Tipo_Cbte)) --para destino y todos los cbtes que dependen del destino
		AND NOT (Id_Estado_Cbte = 3 AND Comprobante_Nro = 0)
		*/
 
		SELECT  
			@Fecha = MAX(Fecha),
			@Comprobante_Nro = ISNULL(MAX(Comprobante_Nro), 0) + 1
		FROM Cbtes
		WHERE 
			Id_Tipo_Cbte IN (
				SELECT Id_Tipo_Cbte 
				FROM Cbtes_Tipos 
				WHERE Id_Tipo_Cbte_Dest = @Id_Tipo_Cbte
				UNION
				SELECT @Id_Tipo_Cbte
			)
			AND NOT (Id_Estado_Cbte = 3 AND Comprobante_Nro = 0);
 
 
	   SET @Fecha = ISNULL(@Fecha,GETDATE())
	   SET @Comprobante_Nro = ISNULL(@Comprobante_Nro, 1)
 
	   IF @Fecha > @Fecha_Cbte
	   BEGIN
			SET @Fecha_Cbte = @Fecha
		END
	END
 
	IF @Id_Estado_Cbte = 0  --si no tenia valor por defecto
	BEGIN
		SET @Id_Estado_Cbte = 1  --Pendiente
 
		IF (@Compromete_Factura <> 0 AND @Id_Cond_Pago = 1 ) OR @Compromete_Recibos <> 0 OR @Compromete_Pagos <> 0
		BEGIN
			SET @Id_Estado_Cbte = 2	 --Completo
		END
	END
 
 
	
	UPDATE Cbtes_Items 		SET Id_Estado_Cbte	= @Id_Estado_Cbte	WHERE	Id_Trans = @pId_Trans
 
 
	UPDATE Cbtes 
		SET 
		Comprobante_Nro = @Comprobante_Nro,
		Fecha = @Fecha_Cbte,
		Id_Estado_Cbte = @Id_Estado_Cbte,
		Cai_Vence  = @Fecha_Cai,
		Cai = @Nro_Cai
		WHERE 
		Id_Trans = @pId_Trans
 
	UPDATE Clientes_CtaCte
		SET	
		Id_Estado_Cbte	= @Id_Estado_Cbte,
		Descripcion		= dbo.CF_Cbte_Descrip(@pId_Trans) --19/11/2020 Agregado
		WHERE	
		Id_Trans = @pId_Trans
 
 
	/*
 
	UPDATE Cbtes_Tipos 
		SET 
		Fecha_Ult = @Fecha_Cbte, 
		Prox_Nro = @Comprobante_Nro + 1
		WHERE 
		Id_Tipo_Cbte = @Id_Tipo_Cbte 
		OR Id_Tipo_Cbte IN (SELECT Id_Tipo_Cbte 
							FROM Cbtes_Tipos 
							WHERE Id_Tipo_Cbte_Dest = @Id_Tipo_Cbte) --para destino y todos los cbtes que dependen del destino
    */
 
 
	DECLARE @TiposAActualizar TABLE (Id_Tipo_Cbte CHAR(4));
 
	INSERT INTO @TiposAActualizar (Id_Tipo_Cbte)
	SELECT Id_Tipo_Cbte
	FROM Cbtes_Tipos
	WHERE Id_Tipo_Cbte_Dest = @Id_Tipo_Cbte
	UNION
	SELECT @Id_Tipo_Cbte;
 
	UPDATE CT
	SET 
		Fecha_Ult = @Fecha_Cbte, 
		Prox_Nro = @Comprobante_Nro + 1
	FROM Cbtes_Tipos CT
	JOIN @TiposAActualizar T ON T.Id_Tipo_Cbte = CT.Id_Tipo_Cbte;
 
	/*===================================================================*/	
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END
	/*===================================================================*/	
 
	IF @pOmitir_Resultado_OK = 0
	BEGIN
		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_Trans', @pId_Trans, 'INT') + ',' +
									dbo.CF_Json_ParsearVariable('comprobante_Nro', @Comprobante_Nro, 'INT') +
									'}'
 
		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@rtaMsjStored	AS ErrorMessage
	END
 
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Grabar_Numero'
	END
END TRY  
 
 
BEGIN CATCH  
    EXECUTE usp_GetErrorInfo
 
	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END
 
	RETURN 9999
END CATCH;   
 
RETURN 0